<?php defined('ABSPATH') || die;
/**
 * acsh SpeedUp Iranian Host Wordpress Dashboard
 *
 * @author            ACSH-academyshadman
 * @copyright         ACSH-academyshadman
 * @license           ACSH-academyshadman
 *
 * @wordpress-plugin
 *
 * Plugin Name:         افزایش سرعت هاست ایرانی
 * Plugin URI:          https://www.academyshadman.com/
 * Description:         افزونه ای جهت افزایش سرعت داشبورد وردپرس در هاست‌های ایرانی
 * Version:             1.0.0
 * Requires at least:   5.0
 * Requires PHP:        7.2
 * Author:              ACSH-academyshadman
 * Author URI:          https://www.academyshadman.com/
 * License:             ACSH License
 * License URI:         https://www.academyshadman.com/
 * Text Domain:         academyshadman
 * Domain Path:         /languages
 */



function acshTextHasString($text, $string) {
	return strpos($text, $string) !== false;
}


function acshBlockExternalHostRequests ($false, $parsed_args, $url) {
	$blockedHosts = [
		'elementor.com',
		'github.com',
		'yoast.com',
		'yoa.st',
		'api.wordpress.org',
		'w.org',
		'unyson.io',
		'siteorigin.com',
		'woocommerce.com'
	];

	foreach ( $blockedHosts as $host ) {
		if ( !empty($host) && acshTextHasString($url, $host) ) {
			return [
				'headers'  => '',
				'body'     => '',
				'response' => '',
				'cookies'  => '',
				'filename' => ''
			];
		}
	}

	return $false;
}
add_filter('pre_http_request', 'acshBlockExternalHostRequests', 10, 3);
